#region References

using System;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.GUI;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.BOL;

#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Summary description for MultipleBloodProductCode.
	/// </summary>
	public class MultipleBloodProductCode
	{
		#region Variables
		
		/// <summary>
		/// _bloodProductsDataTable
		/// </summary>
		private DataTable _bloodProductsDataTable;
		/// <summary>
		/// _productCode
		/// </summary>
		private String _productCode;
		/// <summary>
		/// _parentForm
		/// </summary>
		private System.Windows.Forms.Form _parentForm;
		/// <summary>
		/// _thisUser
		/// </summary>
		private VbecsUser _thisUser;
		/// <summary>
		/// _bloodProduct
		/// </summary>
		private BOL.BloodProduct _bloodProduct;

		#endregion

		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public MultipleBloodProductCode(VbecsUser thisUser, System.Windows.Forms.Form parent, string productCode)
		{
			this._productCode = productCode;
			this._parentForm = parent;
			this._thisUser = thisUser;
			//
			GetBloodProduct(false);
		}
		
		/// <summary>
		/// CR 2210	
		/// </summary>
		public MultipleBloodProductCode(VbecsUser thisUser, System.Windows.Forms.Form parent, string productCode, bool selectLocalProducts)
		{
			this._productCode = productCode;
			this._parentForm = parent;
			this._thisUser = thisUser;
			//
			GetBloodProduct(selectLocalProducts);
		}

		#endregion

		#region Properties

		/// <summary>
		/// Get/Set BloodProductsDataTable
		/// </summary>
		public DataTable BloodProductsDataTable
		{
			get
			{
				return this._bloodProductsDataTable;
			}

			set
			{
				this._bloodProductsDataTable = value;
			}
		}

		/// <summary>
		/// Get/Set BloodProduct
		/// </summary>
		public BOL.BloodProduct BloodProduct
		{
			get
			{
				return this._bloodProduct;
			}
			set
			{
				this._bloodProduct = value;
			}
		}

		#endregion
	
		#region Methods

		/// <summary>
		/// GetBloodProduct	
		/// </summary>
		private void GetBloodProduct(bool selectLocalProducts)	
		{
			try
			{
				if(!selectLocalProducts)
				{
					_bloodProductsDataTable = BOL.BloodProduct.GetBloodProductsByCode(_productCode);
				}
				else
				{
					// CR 2210
					_bloodProductsDataTable = BOL.BloodProduct.GetActiveOrLocalBloodProductsByCode(_productCode);
				}
				//
				switch(_bloodProductsDataTable.Rows.Count)
				{
					case 0:
						if (!this.HasAuthorityToAddProduct())
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.CannotAddBloodProduct());
							return;
						}

						this._bloodProduct = new BOL.BloodProduct(System.Guid.NewGuid());
						break;

					case 1:
						this._bloodProduct = new BOL.BloodProduct(_bloodProductsDataTable.Rows[0]);
						break;

					default:
						DlgSelectBloodProduct dlg = new DlgSelectBloodProduct(_bloodProductsDataTable);
						if (dlg.ShowDialog(this._parentForm) == DialogResult.OK)
						{
							this._bloodProduct = new BOL.BloodProduct(dlg.BloodProduct.BloodProductGuid);
						}
						break;
				}
			}

			catch(BOL.BusinessObjectException err)
			{
				ExceptionManagement.ExceptionManager.Publish(err);
				GuiMessenger.ShowMessageBox(_parentForm, Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
			}
			catch (Exception ex)
			{
				ExceptionManagement.ExceptionManager.Publish(ex);
				GuiMessenger.ShowMessageBox(_parentForm, Common.StrRes.SysErrMsg.Common.Dynamic("System error. Please try again later"));
			}
		}

		/// <summary>
		/// HasAuthorityToEditProduct
		/// </summary>
		/// <returns></returns>
		private bool HasAuthorityToEditProduct()
		{
			return _thisUser.IsAuthorizedForFunction( Common.FunctionCode.ActivateEditBloodProductInformation );
		}

		/// <summary>
		/// HasAuthorityToAddProduct
		/// </summary>
		/// <returns></returns>
		/// TODO: Remove this check in I4
		private bool HasAuthorityToAddProduct()
		{
			return _thisUser.IsAuthorizedForFunction( Common.FunctionCode.AddNewBloodProduct );
		}
		#endregion
	}
}
